/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffSet extends Effect {
	
	static {
		Skript.addEffect(EffSet.class, "set %object% to %object%");
	}
	
	private Variable<?> setter;
	private Variable<?> setted;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		setted = vars.get(0);
		setter = vars.get(1);
		final Class<?> r = setted.acceptChange(ch.njol.skript.api.Changer.ChangeMode.SET);
		if (r == null) {
			throw new ParseException(setted + " can't be set");
		}
		if (r.isAssignableFrom(setter.getReturnType()))
			return;
		Variable<?> v = setter.getConvertedVar(r);
		if (v == null) {
			throw new ParseException(setted + " can't be set to " + setter);
		}
		setter = v;
	}
	
	@Override
	protected void execute(final Event e) {
		setted.change(e, setter.get(e), ChangeMode.SET);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "set " + setted.getDebugMessage(null) + " to " + setter.getDebugMessage(e);
	}
	
}
