/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffRemove extends Effect {
	
	static {
		Skript.addEffect(EffRemove.class, "remove %object% from %object%");
	}
	
	private Variable<?> removed;
	private Variable<?> remover;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		remover = vars.get(0);
		removed = vars.get(1);
		final Class<?> r = removed.acceptChange(ChangeMode.REMOVE);
		if (r == null) {
			throw new ParseException(removed + " can't have something 'removed' from it");
		}
		if (r.isAssignableFrom(remover.getReturnType()))
			return;
		Variable<?> v = remover.getConvertedVar(r);
		if (v == null) {
			throw new ParseException(remover + " can't be removed from " + removed);
		}
		remover = v;
	}
	
	@Override
	protected void execute(final Event e) {
		removed.change(e, remover.get(e), ChangeMode.REMOVE);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "remove " + remover.getDebugMessage(e) + " from " + removed.getDebugMessage(null);
	}
	
}
