/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Location;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffExplosion extends Effect {
	
	static {
		Skript.addEffect(EffExplosion.class, "(create )?explosion (of|with) (force|strength|power) %float%( at %location%)?");
	}
	
	private Variable<Float> forces;
	private Variable<Location> locations;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		forces = (Variable<Float>) vars.get(0);
		locations = (Variable<Location>) vars.get(1);
	}
	
	@Override
	public void execute(final Event e) {
		for (final Float force : forces.get(e)) {
			for (final Location l : locations.get(e)) {
				l.getWorld().createExplosion(l, force);
			}
		}
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "create explosion of force " + forces.getDebugMessage(e) + " at " + locations.getDebugMessage(e);
	}
	
}
