/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class EffExec extends Effect {
	
	static {
		Skript.addEffect(EffExec.class, "exec(ute)? %string%");
	}
	
	private Variable<String> input;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException {
		input = (Variable<String>) vars.get(0);
	}
	
	@Override
	protected void execute(final Event e) {
		final String s = input.get(e)[0];
		if (s == null)
			Skript.info(input.getClass().getName());
		final Effect eff = Effect.parse(s);
		if (eff != null) {
			eff.run(e);
		} else {
			final CommandSender sender = Skript.getEventValue(e, CommandSender.class);
			Skript.printErrorAndCause(sender);
		}
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "exec " + input.getDebugMessage(e);
	}
	
}
