/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffDrop extends Effect {
	
	static {
		Skript.addEffect(EffDrop.class, "drop %itemstack% at %location%", "drop %itemstack%");
	}
	
	private Variable<ItemStack> items;
	private Variable<Location> locations = null;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		items = (Variable<ItemStack>) vars.get(0);
		if (vars.size() > 1)
			locations = (Variable<Location>) vars.get(1);
	}
	
	@Override
	public void execute(final Event e) {
		if (locations == null) {
			if (e instanceof EntityDeathEvent) {
				((EntityDeathEvent) e).getDrops().addAll(Arrays.asList(items.get(e)));
				return;
			}
			final Location l = Skript.getEventValue(e, Location.class);
			for (final ItemStack item : items.get(e)) {
				l.getWorld().dropItemNaturally(l, item);
			}
			return;
		}
		for (final Location l : locations.get(e)) {
			if (l == null)
				continue;
			for (final ItemStack item : items.get(e)) {
				l.getWorld().dropItemNaturally(l, item);
			}
		}
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "drop " + items.getDebugMessage(e) + (locations == null ? "" : " at " + locations.getDebugMessage(e));
	}
	
}
