/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffClear extends Effect {
	
	static {
		Skript.addEffect(EffClear.class, "(clear|delete) %object%");
	}
	
	private Variable<?> cleared;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		cleared = vars.get(0);
		final Class<?> r = cleared.acceptChange(ChangeMode.CLEAR);
		if (r == null) {
			throw new ParseException(cleared + " can't be cleared/deleted");
		}
	}
	
	@Override
	protected void execute(final Event e) {
		cleared.change(e, null, ChangeMode.CLEAR);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "clear " + cleared.getDebugMessage(null);
	}
	
}
