/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class EffAdd extends Effect {
	
	static {
		Skript.addEffect(EffAdd.class, "(add|give) %object% to %object%");
	}
	
	private Variable<?> added;
	private Variable<?> adder;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		adder = vars.get(0);
		added = vars.get(1);
		final Class<?> r = added.acceptChange(ch.njol.skript.api.Changer.ChangeMode.ADD);
		if (r == null) {
			throw new ParseException(added + " can't have something 'added' to it");
		}
		if (r.isAssignableFrom(adder.getReturnType()))
			return;
		Variable<?> v = adder.getConvertedVar(r);
		if (v == null) {
			throw new ParseException(adder + " can't be added to " + added);
		}
		adder = v;
	}
	
	@Override
	protected void execute(final Event e) {
		added.change(e, added.get(e), ch.njol.skript.api.Changer.ChangeMode.ADD);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "add " + adder.getDebugMessage(e) + " to " + added.getDebugMessage(null);
	}
	
}
