/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.data;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.ContainerBlock;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Slot;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.util.ItemType;

/**
 * @author Peter Gttinger
 * 
 */
public class DefaultConverters {
	
	public DefaultConverters() {}
	
	static {
		
		// OfflinePlayer - PlayerInventory
		Skript.addConverter(OfflinePlayer.class, PlayerInventory.class, new Converter<OfflinePlayer, PlayerInventory>() {
			@Override
			public PlayerInventory convert(final OfflinePlayer p) {
				if (p == null || !p.isOnline())
					return null;
				return p.getPlayer().getInventory();
			}
		});
		Skript.addConverter(PlayerInventory.class, OfflinePlayer.class, new Converter<PlayerInventory, OfflinePlayer>() {
			@Override
			public OfflinePlayer convert(final PlayerInventory i) {
				if (i == null)
					return null;
				for (final Player p : Bukkit.getOnlinePlayers()) {
					if (p.getInventory() == i)
						return p;
				}
				return null;
			}
		});
		
		// CommandSender - Player
		Skript.addConverter(CommandSender.class, Player.class, new Converter<CommandSender, Player>() {
			@Override
			public Player convert(final CommandSender s) {
				if (s instanceof Player)
					return (Player) s;
				return null;
			}
		});
		
		// Block - Inventory
		Skript.addConverter(Block.class, Inventory.class, new Converter<Block, Inventory>() {
			@Override
			public Inventory convert(final Block b) {
				if (b == null)
					return null;
				if (b.getState() instanceof ContainerBlock)
					return ((ContainerBlock) b.getState()).getInventory();
				return null;
			}
		});
		
		// Entity - Location
		Skript.addConverter(Entity.class, Location.class, new Converter<Entity, Location>() {
			@Override
			public Location convert(final Entity e) {
				if (e == null)
					return null;
				return e.getLocation();
			}
		});
		
		// Location - Block
		Skript.addConverter(Location.class, Block.class, new Converter<Location, Block>() {
			@Override
			public Block convert(final Location l) {
				if (l == null)
					return null;
				return l.getBlock();
			}
		});
		Skript.addConverter(Block.class, Location.class, new Converter<Block, Location>() {
			@Override
			public Location convert(final Block b) {
				if (b == null)
					return null;
				return b.getLocation().add(0.5, 0.5, 0.5);
			}
		});
		
		// ItemType - ItemStack
		Skript.addConverter(ItemType.class, ItemStack.class, new Converter<ItemType, ItemStack>() {
			@Override
			public ItemStack convert(final ItemType i) {
				if (i == null)
					return null;
				return i.getRandom();
			}
		});
		Skript.addConverter(ItemStack.class, ItemType.class, new Converter<ItemStack, ItemType>() {
			@Override
			public ItemType convert(final ItemStack i) {
				if (i == null)
					return null;
				return new ItemType(i);
			}
		});
		
		// Slot - ItemStack
		Skript.addConverter(Slot.class, ItemStack.class, new Converter<Slot, ItemStack>() {
			@Override
			public ItemStack convert(final Slot s) {
				return s.getItem();
			}
		});
		
		// Slot - Inventory
		Skript.addConverter(Slot.class, Inventory.class, new Converter<Slot, Inventory>() {
			@Override
			public Inventory convert(final Slot s) {
				return s.getInventory();
			}
		});
	}
}
