/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.data;

import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ContainerBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Slot;

import ch.njol.skript.api.Changer;
import ch.njol.skript.util.ItemType;

/**
 * @author Peter Gttinger
 * 
 */
public class DefaultChangers {
	
	public DefaultChangers() {}
	
	public final static Changer<Block> blockChanger = new Changer<Block>() {
		
		@Override
		public Class<?> acceptChange(final ChangeMode mode) {
			return ItemType.class;
		}
		
		@Override
		public void change(final Block[] blocks, final Object[] delta, final ch.njol.skript.api.Changer.ChangeMode mode) {
			for (final Block block : blocks) {
				switch (mode) {
					case SET:
						((ItemType) delta[0]).setBlock(block, true);
						return;
					case CLEAR:
						block.setTypeId(0, true);
						return;
					case ADD:
					case REMOVE:
						BlockState state = block.getState();
						if (!(state instanceof ContainerBlock))
							continue;
						if (mode == ChangeMode.ADD) {
							for (ItemType type:(ItemType[]) delta)
								((ContainerBlock) state).getInventory().addItem(type.getRandom());
						} else {
							for (ItemType type:(ItemType[]) delta)
								type.removeFrom(((ContainerBlock) state).getInventory());
						}
						state.update();
						return;
				}
			}
		}
		
	};
	
	public final static Changer<Inventory> inventoryChanger = new Changer<Inventory>() {
		
		@Override
		public Class<?> acceptChange(final ch.njol.skript.api.Changer.ChangeMode mode) {
			return ItemType.class;
		}
		
		@SuppressWarnings("deprecation")
		@Override
		public void change(final Inventory[] invis, final Object[] delta, final ch.njol.skript.api.Changer.ChangeMode mode) {
			for (final Inventory invi : invis) {
				switch (mode) {
					case SET:
						invi.clear();
						//$FALL-THROUGH$
					case ADD:
						for (final ItemType type : (ItemType[]) delta)
							invi.addItem(type.getRandom());
					break;
					case REMOVE:
						for (final ItemType type : (ItemType[]) delta)
							type.removeFrom(invi);
					break;
					case CLEAR:
						invi.clear();
				}
				if (invi instanceof PlayerInventory) {
					final Player p = Bukkit.getPlayerExact(((PlayerInventory) invi).getName());
					if (p != null)
						p.updateInventory();
				}
			}
		}
		
	};
	
	public final static Changer<Slot> slotChanger = new Changer<Slot>() {
		
		@Override
		public Class<?> acceptChange(final ch.njol.skript.api.Changer.ChangeMode mode) {
			return ItemType.class;
		}
		
		@Override
		public void change(final Slot[] slots, final Object[] delta, final ch.njol.skript.api.Changer.ChangeMode mode) {
			for (final Slot slot : slots) {
				final ItemType type = (ItemType) delta[0];
				switch (mode) {
					case SET:
						slot.getInventory().setItem(slot.getIndex(), type.getRandom());
					break;
					case ADD:
						slot.getInventory().setItem(slot.getIndex(), type.addTo(slot.getItem()));
					break;
					case REMOVE:
						slot.getInventory().setItem(slot.getIndex(), type.removeFrom(slot.getItem()));
					break;
					case CLEAR:
						slot.getInventory().setItem(slot.getIndex(), null);
				}
			}
		}
		
	};
	
}
