/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.data;

import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDamageEvent.DamageCause;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.vehicle.VehicleEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Getter;

/**
 * @author Peter Gttinger
 * 
 */
public final class BukkitEventValues {
	
	public BukkitEventValues() {}
	
	static {
		
		// === WorldEvents ===
		Skript.addEventValue(WorldEvent.class, World.class, new Getter<World, WorldEvent>() {
			@Override
			public World get(final WorldEvent e) {
				return e.getWorld();
			}
		});
		
		// === BlockEvents ===
		Skript.addEventValue(BlockEvent.class, Block.class, new Getter<Block, BlockEvent>() {
			@Override
			public Block get(final BlockEvent e) {
				return e.getBlock();
			}
		});
		// BlockBreakEvent
		Skript.addEventValue(BlockBreakEvent.class, Player.class, new Getter<Player, BlockBreakEvent>() {
			@Override
			public Player get(final BlockBreakEvent e) {
				return e.getPlayer();
			}
		});
		// BlockIgniteEvent
		Skript.addEventValue(BlockIgniteEvent.class, Player.class, new Getter<Player, BlockIgniteEvent>() {
			@Override
			public Player get(final BlockIgniteEvent e) {
				return e.getPlayer();
			}
		});
		// BlockDamageEvent
		Skript.addEventValue(BlockDamageEvent.class, Player.class, new Getter<Player, BlockDamageEvent>() {
			@Override
			public Player get(final BlockDamageEvent e) {
				return e.getPlayer();
			}
		});
		// BlockDispenseEvent
		Skript.addEventValue(BlockDispenseEvent.class, ItemStack.class, new Getter<ItemStack, BlockDispenseEvent>() {
			@Override
			public ItemStack get(final BlockDispenseEvent e) {
				return e.getItem();
			}
		});
		// BlockPistonEvent
		Skript.addEventValue(BlockPistonEvent.class, BlockFace.class, new Getter<BlockFace, BlockPistonEvent>() {
			@Override
			public BlockFace get(final BlockPistonEvent e) {
				return e.getDirection();
			}
		});
		
		// === EntityEvents ===
		Skript.addEventValue(EntityEvent.class, Entity.class, new Getter<Entity, EntityEvent>() {
			@Override
			public Entity get(final EntityEvent e) {
				return e.getEntity();
			}
		});
		// EntityDeathEvent
		Skript.addEventValue(EntityDeathEvent.class, ItemStack[].class, new Getter<ItemStack[], EntityDeathEvent>() {
			@Override
			public ItemStack[] get(final EntityDeathEvent e) {
				return e.getDrops().toArray(new ItemStack[0]);
			}
		});
		// EntityDamageEvent
		Skript.addEventValue(EntityDamageEvent.class, DamageCause.class, new Getter<DamageCause, EntityDamageEvent>() {
			@Override
			public DamageCause get(final EntityDamageEvent e) {
				return e.getCause();
			}
		});
		
		// --- PlayerEvents ---
		Skript.addEventValue(PlayerEvent.class, Player.class, new Getter<Player, PlayerEvent>() {
			@Override
			public Player get(final PlayerEvent e) {
				return e.getPlayer();
			}
		});
		// PlayerBedEnterEvent
		Skript.addEventValue(PlayerBedEnterEvent.class, Block.class, new Getter<Block, PlayerBedEnterEvent>() {
			@Override
			public Block get(final PlayerBedEnterEvent e) {
				return e.getBed();
			}
		});
		// PlayerBedLeaveEvent
		Skript.addEventValue(PlayerBedLeaveEvent.class, Block.class, new Getter<Block, PlayerBedLeaveEvent>() {
			@Override
			public Block get(final PlayerBedLeaveEvent e) {
				return e.getBed();
			}
		});
		// PlayerBucketEvent
		Skript.addEventValue(PlayerBucketEvent.class, Block.class, new Getter<Block, PlayerBucketEvent>() {
			@Override
			public Block get(final PlayerBucketEvent e) {
				return e.getBlockClicked().getRelative(e.getBlockFace());
			}
		});
		// PlayerDropItemEvent
		Skript.addEventValue(PlayerDropItemEvent.class, Item.class, new Getter<Item, PlayerDropItemEvent>() {
			@Override
			public Item get(final PlayerDropItemEvent e) {
				return e.getItemDrop();
			}
		});
		Skript.addEventValue(PlayerDropItemEvent.class, ItemStack.class, new Getter<ItemStack, PlayerDropItemEvent>() {
			@Override
			public ItemStack get(final PlayerDropItemEvent e) {
				return e.getItemDrop().getItemStack();
			}
		});
		// PlayerInteractEntityEvent
		Skript.addEventValue(PlayerInteractEntityEvent.class, Entity.class, new Getter<Entity, PlayerInteractEntityEvent>() {
			@Override
			public Entity get(final PlayerInteractEntityEvent e) {
				return e.getRightClicked();
			}
		});
		// PlayerInteractEvent
		Skript.addEventValueBefore(PlayerInteractEvent.class, PlayerEvent.class, Block.class, new Getter<Block, PlayerInteractEvent>() {
			@Override
			public Block get(final PlayerInteractEvent e) {
				return e.getClickedBlock();
			}
		});
		// PlayerShearEntityEvent
		Skript.addEventValue(PlayerShearEntityEvent.class, Entity.class, new Getter<Entity, PlayerShearEntityEvent>() {
			@Override
			public Entity get(final PlayerShearEntityEvent e) {
				return e.getEntity();
			}
		});
		
		// --- VehicleEvents ---
		Skript.addEventValue(VehicleEvent.class, Vehicle.class, new Getter<Vehicle, VehicleEvent>() {
			@Override
			public Vehicle get(final VehicleEvent e) {
				return e.getVehicle();
			}
		});
		Skript.addEventValue(VehicleExitEvent.class, LivingEntity.class, new Getter<LivingEntity, VehicleExitEvent>() {
			@Override
			public LivingEntity get(final VehicleExitEvent e) {
				return e.getExited();
			}
		});
		Skript.addEventValue(VehicleEvent.class, Entity.class, new Getter<Entity, VehicleEvent>() {
			@Override
			public Entity get(final VehicleEvent e) {
				return e.getVehicle().getPassenger();
			}
		});
		
	}
	
}
