/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.World;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.WeatherType;
import ch.njol.util.Checker;

/**
 * @author Peter Gttinger
 * 
 */
public class CondWeather extends Condition {
	
	static {
		Skript.addCondition(CondWeather.class, "is %weathertype%( in %world%)?");
	}
	
	private Variable<WeatherType> weathers;
	private Variable<World> worlds;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		weathers = (Variable<WeatherType>) vars.get(0);
		worlds = (Variable<World>) vars.get(1);
	}
	
	@Override
	public boolean run(final Event e) {
		return weathers.check(e, new Checker<WeatherType>() {
			@Override
			public boolean check(final WeatherType wt) {
				return worlds.check(e, new Checker<World>() {
					@Override
					public boolean check(final World w) {
						return wt.isWeather(w);
					}
				}, isNegated(), false);
			}
		}, isNegated(), false);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "is " + weathers.getDebugMessage(e) + " in " + worlds.getDebugMessage(e);
	}
	
}
