/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.VariableString;
import ch.njol.util.Checker;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class CondPermission extends Condition {
	
	static {
		Skript.addCondition(CondPermission.class,
				"(%commandsender% )?(do(es)n't|don't|do(es) not) have (the )?permissions? %variablestring%",
				"(%commandsender% )?ha(s|ve) (the )?permissions? %variablestring%");
	}
	
	private Variable<VariableString> permissions;
	private Variable<CommandSender> senders;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		senders = (Variable<CommandSender>) vars.get(0);
		permissions = (Variable<VariableString>) vars.get(1);
		setNegated(matchedPattern == 0);
	}
	
	@Override
	public boolean run(final Event e) {
		return senders.check(e, new Checker<CommandSender>() {
			@Override
			public boolean check(final CommandSender s) {
				return permissions.check(e, new Checker<VariableString>() {
					@Override
					public boolean check(final VariableString perm) {
						final String p = perm.get(e);
						if (s.hasPermission(p))
							return true;
						// player has perm skript.foo.bar if he has skript.foo.* or skript.*, but not for other plugin's permissions since they can define their own *
						if (p.startsWith("skript.")) {
							for (int i = p.lastIndexOf("."); i > 0; i = p.lastIndexOf(p, i - 1)) {
								if (s.hasPermission(p.substring(0, i + 1) + "*"))
									return true;
							}
						}
						return false;
					}
				}, isNegated(), false);
			}
		}, isNegated(), false);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return senders.getDebugMessage(e) + " has permission " + senders.getDebugMessage(e);
	}
	
}
