/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Comparator;
import ch.njol.skript.api.Comparator.ComparatorInfo;
import ch.njol.skript.api.Comparator.Relation;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class CondIs extends Condition {
	
	static {
		Skript.addCondition(CondIs.class,
				"%object% ((is|are) (greater|more|higher) than|>) &object%",
				"%object% ((is|are) (less|smaller) than|<) &object%",
				"%object% ((is|are) not|isn't|aren't|!=) &object%",
				"%object% (is|are|=) %object%");
	}
	
	private Variable<?> first, second;
	private Relation relation;
	private Comparator<?,?> comp;
	private boolean reverseOrder = false;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		first = vars.get(0);
		second = vars.get(1);
		relation = Relation.values()[(matchedPattern + 1) % 4];
		Class<?> f = first.getReturnType(), s = second.getReturnType();
		Variable<?> temp = null;
		int tempIndex = 0;
		for (ComparatorInfo<?,?> info:Skript.getComparators()) {
			
			//TODO comp supports >, < or only =, !=
			
			if (info.c1.isAssignableFrom(f) && info.c2.isAssignableFrom(s)
					|| info.c1.isAssignableFrom(s) && info.c2.isAssignableFrom(f)) {
				comp = info.c;
				reverseOrder = !(info.c1.isAssignableFrom(f) && info.c2.isAssignableFrom(s));
				return;
			} else if (comp != null) {
				for (int c = 0; c <= 1; c++) {
					for (int v = 0; v <= 1; v++) {
						if (info.getType(c).isAssignableFrom((v == 0 ? f : s))) {
							temp = (v == 0 ? first : second).getConvertedVar(info.getType(1-c));
							if (temp != null) {
								tempIndex = v;
								reverseOrder = c != v;
								comp = info.c;
								c = 1;
								break;
							}
						}
					}
				}
			}
		}
		if (comp != null) {
			if (tempIndex == 0) first = temp;
			else second = temp;
			return;
		} else {
			for (ComparatorInfo<?, ?> info:Skript.getComparators()) {
				for (int c = 0; c <= 1; c++) {
					Variable<?> v1 = first.getConvertedVar(info.getType(c));
					Variable<?> v2 = second.getConvertedVar(info.getType(1-c));
					if (v1 != null && v2 != null) {
						first = v1;
						second = v2;
						reverseOrder = c == 1;
						comp = info.c;
						return;
					}
				}
			}
		}
		
		throw new ParseException("the given values can't be compared");
	}
	
	@Override
	public boolean run(final Event e) {
		final Object o1 = first.get(e);
		final Object o2 = second.get(e);
		return relation.is(reverseOrder ? compare(o2, o1) : compare(o1, o2));
	}
	
	@SuppressWarnings("unchecked")
	private <T1, T2> Relation compare(T1 o1, T2 o2) {
		return ((Comparator<? super T1, ? super T2>) comp).compare(o1, o2);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return first.getDebugMessage(e) + " is " + second.getDebugMessage(e);
	}
	
}
