/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class CondChance extends Condition {
	
	static {
		Skript.addCondition(CondChance.class, "chance of (\\d+(.\\d+)?)%");
	}
	
	private double chance;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException {
		chance = Double.parseDouble(matcher.group(1)) / 100;
	}
	
	@Override
	public boolean run(final Event e) {
		return Math.random() < chance;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "chance of " + chance * 100 + "%";
	}
	
}
