/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.conditions;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Condition;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;

/**
 * @author Peter Gttinger
 * 
 */
public class CondCanHold extends Condition {
	
	static {
		Skript.addCondition(CondCanHold.class,
				"(%inventory% )?(can hold|ha(s|ve) (enough )?space (for|to hold)) %itemstack%",
				"(%inventory% )?(cann['o]t hold|(ha(s|ve) not|ha(s|ve)n't|do(es)?n't have) (enough )?space (for|to hold)) %itemstack%");
	}
	
	private Variable<Inventory> invis;
	private Variable<ItemStack> items;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		invis = (Variable<Inventory>) vars.get(0);
		items = (Variable<ItemStack>) vars.get(1);
		setNegated(matchedPattern == 1);
	}
	
	@Override
	public boolean run(final Event e) {
		final ItemStack[] items = this.items.get(e);
		return invis.check(e, new Checker<Inventory>() {
			@Override
			public boolean check(final Inventory i) {
				return Utils.canHold(i, items);
			}
		}, isNegated(), false);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return invis.getDebugMessage(e) + " can hold " + items.getDebugMessage(e);
	}
	
}
