/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

import java.util.List;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.Trigger;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.config.SectionNode;

/**
 * @author Peter Gttinger
 * 
 */
public abstract class TriggerSection extends TriggerItem {
	
	private final List<TriggerItem> items;
	
	private boolean stopped = false;
	
	private static String indentation = "  ";
	
	/**
	 * reserved for new Trigger(...)
	 */
	protected TriggerSection(final List<TriggerItem> items) {
		this.items = items;
	}
	
	protected TriggerSection(final SectionNode node) {
		TriggerFileLoader.currentSections.add(this);
		items = TriggerFileLoader.loadItems(node);
		TriggerFileLoader.currentSections.remove(TriggerFileLoader.currentSections.size() - 1);
	}
	
	protected void run(final Event e, final boolean run) {
		if (Skript.logVeryHigh() && !(this instanceof Trigger))
			Skript.info(indentation + (run ? "" : "-") + getDebugMessage(e) + ":");
		if (!run)
			return;
		stopped = false;
		if (Skript.logVeryHigh() && !(this instanceof Trigger))
			indentation += "  ";
		for (final TriggerItem i : items) {
			final boolean ok = i.run(e);
			if (Skript.logVeryHigh() && !(i instanceof TriggerSection)) {
				if (!stopped)
					Skript.info(indentation + (ok ? "" : "-") + i.getDebugMessage(e));
				else
					Skript.info(indentation + "#" + i.getDebugMessage(e));
			}
			if (!ok)
				break;
			if (stopped) {
				stopped = false;
				break;
			}
		}
		if (Skript.logVeryHigh() && !(this instanceof Trigger))
			indentation = indentation.substring(indentation.length() - 2);
	}
	
	public void stop() {
		stopped = true;
	}
	
}
