/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

import org.bukkit.event.Event;

import ch.njol.skript.api.Debuggable;

public abstract class TriggerItem implements Debuggable {
	
	private TriggerItem parent;
	
	public abstract boolean run(Event e);
	
	final public void setParent(final TriggerItem parent) {
		this.parent = parent;
	}
	
	final public TriggerItem getParent() {
		return parent;
	}
	
}
