/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

/**
 * This exception is thrown if the API is used incorrectly.
 * 
 * @author Peter Gttinger
 * 
 */
public class SkriptAPIException extends RuntimeException {
	
	private static final long serialVersionUID = 154696276104637157L;
	
	public SkriptAPIException(final String message) {
		super(message);
	}
	
	public SkriptAPIException(final String message, final Throwable cause) {
		super(message, cause);
	}
	
	public final static void inaccessibleConstructor(final Class<?> c, final IllegalAccessException e) throws SkriptAPIException {
		throw new SkriptAPIException("the constructor of " + c.getName() + " is not public", e);
	}
	
	public final static void instantiationException(final Class<?> c, final InstantiationException e) throws SkriptAPIException {
		throw new SkriptAPIException(c.getName() + " can't be instantiated", e);
	}
	
	public final static void instantiationException(final String desc, final Class<?> c, final InstantiationException e) throws SkriptAPIException {
		throw new SkriptAPIException(desc + " " + c.getName() + " can't be instantiated", e);
	}
	
}
