/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

import java.lang.reflect.Array;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;

/**
 * @author Peter Gttinger
 * 
 */
public class ParsedLiteral extends Literal<String> {
	
	public ParsedLiteral(final String[] data, final boolean and) {
		super(data, String.class, and);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <R> Literal<R> getConvertedVar(final Class<R> to) {
		// strings have to be enclosed in quotes!
//		if (String.class.isAssignableFrom(to))
//			return (Literal<R>) this;
		if (to == Object.class)
			throw new SkriptAPIException("");
		final Converter<String, ? extends R> p = Skript.getParser(to);
		if (p == null)
			return null;
		final R[] parsedData = (R[]) Array.newInstance(to, data.length);
		for (int i = 0; i < data.length; i++) {
			if ((parsedData[i] = p.convert(data[i])) == null) {
				Skript.setErrorCause("'" + data[i] + "' is not a(n) "+ to.getSimpleName(), true);
				return null;
			}
		}
		return new Literal<R>(parsedData, to, and);
	}
	
}
