/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

import org.bukkit.event.Event;

import ch.njol.skript.api.LoopVar;
import ch.njol.skript.config.SectionNode;

public class Loop extends TriggerSection {
	
	private final LoopVar<?> var;
	
	public <T> Loop(final LoopVar<?> var, final SectionNode node) {
		super(node);
		this.var = var;
	}
	
	@Override
	public boolean run(final Event e) {
		var.startLoop(e);
		while (var.hasNext()) {
			var.next();
			super.run(e, true);
		}
		return true;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "loop " + var.getDebugMessage(e);
	}
	
}
