/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class Literal<T> extends Variable<T> {
	
	protected final T[] data;
	protected final Class<T> c;
	
	public Literal(final T[] data, final Class<T> c, final boolean and) {
		this.data = data;
		this.c = c;
		setAnd(and);
	}
	
	@SuppressWarnings("unchecked")
	public Literal(final T data) {
		this.data = (T[]) Array.newInstance(data.getClass(), 1);
		this.data[0] = data;
		c = (Class<T>) data.getClass();
		and = true;
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@Override
	protected T[] getAll(final Event e) {
		return data;
	}
	
	@Override
	public Class<T> getReturnType() {
		return c;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <R> Literal<R> getConvertedVar(final Class<R> to) {
		if (c.isAssignableFrom(to))
			return (Literal<R>) this;
		final Converter<? super T, ? extends R> p = Skript.getConverter(c, to);
		if (p == null)
			return null;
		final R[] parsedData = (R[]) Array.newInstance(to, data.length);
		for (int i = 0; i < data.length; i++)
			parsedData[i] = p.convert(data[i]);
		return new Literal<R>(parsedData, to, and);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "[" + this + "]";
	}
	
	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		for (int i = 0; i < data.length; i++) {
			if (i != 0) {
				if (i == data.length - 1)
					b.append(and ? " and " : " or ");
				else
					b.append(", ");
			}
			b.append(data[i]);
		}
		return b.toString();
	}
	
}
