/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class ConvertedVariable<F, T> extends Variable<T> {
	
	private final Variable<?> var;
	private final Converter<? super F, ? extends T> converter;
	private final Class<T> to;
	
	private ConvertedVariable(final Variable<?> var, final Converter<? super F, ? extends T> converter, final Class<T> to) {
		this.var = var;
		this.converter = converter;
		this.to = to;
	}
	
	public static <F, T> ConvertedVariable<?, T> newInstance(final Variable<F> v, final Class<T> to) {
		if (v == null)
			return null;
		if (v instanceof ConvertedVariable) {
			return newInstance(((ConvertedVariable<?, ?>) v).var, to);
		}
		return newInstance(v, v.getReturnType(), to);
	}
	
	@SuppressWarnings("unchecked")
	public static <F, T> ConvertedVariable<F, T> newInstance(final Variable<F> v, final Class<? extends F> from, final Class<T> to) {
		final Converter<? super F, ? extends T> c = (Converter<? super F, ? extends T>) Skript.getConverter(from, to);
		if (c == null)
			return null;
		return new ConvertedVariable<F, T>(v, c, to);
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@SuppressWarnings("unchecked")
	@Override
	protected T[] getAll(final Event e) {
		final Object[] fs = var.get(e);
		final T[] ts = (T[]) Array.newInstance(to, fs.length);
		for (int i = 0; i < fs.length; i++) {
			ts[i] = converter.convert((F) fs[i]);
		}
		return ts;
	}
	
	@Override
	public void setAnd(final boolean and) {
		super.setAnd(and);
		var.setAnd(and);
	}
	
	@Override
	public Class<T> getReturnType() {
		return to;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return var.getDebugMessage(e) + "->" + to.getName();
		return var.getDebugMessage(e);
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return var.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		var.change(e, delta, mode);
	}
	
	@Override
	public String toString() {
		return var.toString();
	}
	
}
