/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

import org.bukkit.event.Event;

import ch.njol.skript.api.Condition;
import ch.njol.skript.config.SectionNode;

/**
 * @author Peter Gttinger
 * 
 */
public class Conditional extends TriggerSection {
	
	Condition cond;
	
	public Conditional(final Condition cond, final SectionNode node) {
		super(node);
		this.cond = cond;
	}
	
	@Override
	public boolean run(final Event e) {
		super.run(e, cond.run(e));
		return true;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return cond.getDebugMessage(e);
	}
	
}
