/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api.intern;

import ch.njol.skript.api.Converter;

public final class ChainedConverter<F, M, T> implements Converter<F, T> {
	
	private final Converter<? super F, ? extends M> first;
	private final Converter<? super M, ? extends T> second;
	
	public ChainedConverter(final Converter<? super F, ? extends M> first, final Converter<? super M, ? extends T> second) {
		this.first = first;
		this.second = second;
	}
	
	@SuppressWarnings("unchecked")
	public final static <F, M, T> ChainedConverter<F, M, T> newInstance(final Converter<? super F, ?> first, @SuppressWarnings("unused") final Class<M> m, final Converter<?, ? extends T> second) {
		return new ChainedConverter<F, M, T>((Converter<? super F, ? extends M>) first, (Converter<? super M, ? extends T>) second);
	}
	
	@Override
	public T convert(final F f) {
		final M m = first.convert(f);
		if (m == null)
			return null;
		return second.convert(m);
	}
	
}
