/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.api.Expression.ExpressionInfo;
import ch.njol.skript.api.Expression.Expressions;

/**
 * 
 * 
 * @author Peter Gttinger
 * 
 */
public abstract class SkriptEvent implements Debuggable {
	
	public static class SkriptEventInfo extends ExpressionInfo {
		
		public Class<? extends Event>[] events;
		public Class<? extends SkriptEvent> c;
		
		public SkriptEventInfo(final String[] patterns, final Class<? extends SkriptEvent> c, final Class<? extends Event>[] events) {
			super(patterns, null);
			this.c = c;
			this.events = events;
		}
	}
	
	/**
	 * called just after the constructor
	 * 
	 * @param args
	 * @return
	 */
	public abstract void init(final Object[][] args, int matchedPattern, Matcher matcher);
	
	/**
	 * checks whether the given Event applies, e.g. the leftclick event is only part of the PlayerInteractEvent, and this checks whether the player rightclicked or not. This method
	 * will only be called for events this SkriptEvent is registered for.
	 * 
	 * @param e
	 * @return true in most cases.
	 */
	public abstract boolean check(Event e);
	
	/**
	 * @param name
	 * @return
	 */
	public static SkriptEvent parse(final String s) {
		return Expressions.parseEvent(s);
	}
	
}
