/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import ch.njol.skript.Skript;

/**
 * A parser used to parse data from a string. <br/>
 * see also: {@link Skript#addClass(String, Class, Class, Parser, String...)}
 * 
 * @author Peter Gttinger
 * 
 * @param <T> the type of this parser
 */
public abstract class Parser<T> implements Converter<String, T> {
	
	/**
	 * Parses the input. <b>This function must not throw and/or print exceptions/syntax errors</b> but return null instead.
	 * 
	 * @param s the String to parse
	 * @return the parsed input or null if the input is invalid for this parser.
	 */
	public abstract T parse(String s);
	
	@Override
	public final T convert(final String s) {
		return parse(s);
	}
	
	/**
	 * Returns a string representation of the given object to be used in messages.
	 * 
	 * @param o The object. This will never be <code>null</code>.
	 * @return The String representation of the object.
	 */
	public abstract String toString(T o);
}
