/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import java.lang.reflect.Array;
import java.util.Iterator;

import org.bukkit.event.Event;

/**
 * A variable that can be looped. <br/>
 * Please note: <br/>
 * this class extends Variable, thus it has its functions add(), set() and remove() which have event arguments. You usually don't need them, what you need is {@link #current()}.
 * 
 * @author Peter Gttinger
 * 
 */
public abstract class LoopVar<T> extends Variable<T> implements Iterator<T> {
	
	/**
	 * holds information about a loop variable
	 * 
	 * @author Peter Gttinger
	 * 
	 */
	public static class LoopInfo<T> extends VariableInfo<T> {
		
		public String var;
		
		public LoopInfo(final Class<? extends LoopVar<T>> c, final Class<T> returnType, final String var, final String[] patterns) {
			super(patterns, returnType, c);
			this.var = var;
		}
		
	}
	
	private Iterator<T> iter;
	protected T current;
	
	/**
	 * 
	 * 
	 * @param e the event
	 * @return an itetrator to iterate over all values of the event
	 */
	protected abstract Iterator<T> iterator(final Event e);
	
	public final void startLoop(final Event e) {
		iter = iterator(e);
	}
	
	@Override
	public final boolean hasNext() {
		if (iter == null)
			return false;
		return iter.hasNext();
	}
	
	@Override
	public final T next() {
		return current = iter.next();
	}
	
	@Override
	public final void remove() {
		throw new UnsupportedOperationException();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected final T[] getAll(final Event e) {
		final T[] t = (T[]) Array.newInstance(current.getClass(), 1);
		t[0] = current;
		return t;
	}
	
	/**
	 * This is the function you should use in set(), add(), etc., simply ignore the events given to those functions.
	 * 
	 * @return the current value of the loop
	 */
	public final T current() {
		return current;
	}
	
}
