/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

/**
 * Used to get a specific value from instances of the same type. The kind of value depends on where and how this getter is used.
 * 
 * @author Peter Gttinger
 * 
 * @param <R> the returned value type
 * @param <A> the type which holds the value
 */
public interface Getter<R, A> {
	
	/**
	 * Gets a value from the given object.
	 * 
	 * @param arg the object to get teh value from
	 * @return the value
	 */
	public R get(A arg);
	
}
