/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

/**
 * used to convert data from one type to another.
 * 
 * @author Peter Gttinger
 * 
 * @param <F> the accepted type of objects to convert
 * @param <T> the type to convert to
 */
public interface Converter<F, T> {
	
	/**
	 * holds information about a converter
	 * 
	 * @author Peter Gttinger
	 * 
	 * @param <F> same as {@link Converter}
	 * @param <T> dito
	 */
	public static final class ConverterInfo<F, T> {
		
		public Class<F> from;
		public Class<T> to;
		public Converter<F, T> converter;
		
		public ConverterInfo(final Class<F> from, final Class<T> to, final Converter<F, T> converter) {
			this.from = from;
			this.to = to;
			this.converter = converter;
		}
		
	}
	
	/**
	 * converts an object from the given to the desired type
	 * 
	 * @param f The object to convert which can be null.
	 * @return the converted object
	 */
	public T convert(F f);
	
	public static final class ConverterUtils {
		
		/**
		 * Converts a value using a ConverterInfo. Does not throw an error if the given object is of the wrong type, but returns null instead.
		 * 
		 * @param info
		 * @param o
		 * @return info.converter.convert(o) or null if o is not of the correct type.
		 */
		@SuppressWarnings("unchecked")
		public final static <T, F> T convert(final ConverterInfo<F, T> info, final Object o) {
			if (info.from.isInstance(o))
				return info.converter.convert((F) o);
			return null;
		}
		
	}
	
}
