/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.intern.TopLevelExpression;
import ch.njol.util.Checker;

/**
 * 
 * A condition which must be fulfilled for the trigger to continue. If the condition is in a section the section is exited and execution resumes from the element after the section.
 * If the condition is in a loop, execution resumes from the beginning of the loop if there are stil elements to loop left.
 * 
 * @author Peter Gttinger
 * 
 */
public abstract class Condition extends TopLevelExpression {
	
	private boolean negated = false;
	
	protected Condition() {}
	
	/**
	 * Checks whether this condition is satisfied with the given event. This should not alter the event or the world in any way, as conditions are only checked until one returns
	 * false. All subsequent conditions of the same trigger will then be omitted.<br/>
	 * <br/>
	 * You might want to use {@link Variable#check(Event, Checker)}
	 * 
	 * @param e the event to check
	 * @return <code>true</code> if the condition is satisfied, <code>false</code> otherwise or if the condition doesn't apply to this event.
	 */
	@Override
	public abstract boolean run(final Event e);
	
	/**
	 * Sets the negation status of this condition. This will change the behaviour of {@link Variable#check(Event, Checker, Condition)}.
	 * 
	 * @param invert
	 */
	protected final void setNegated(final boolean invert) {
		negated = invert;
	}
	
	/**
	 * 
	 * @return whether this condition is negated or not.
	 */
	public final boolean isNegated() {
		return negated;
	}
	
	public static Condition parse(final String s) {
		return (Condition) Expressions.parse(s, Skript.getConditions().iterator());
	}
	
}
