/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.api;


/**
 * @author Peter Gttinger
 * 
 */
public interface Changer<T> {
	
	public static enum ChangeMode {
		ADD, SET, REMOVE, CLEAR;
	}
	
	/**
	 * 
	 * @param what
	 * @param delta an array of the type accepted by {@link #acceptChange(ChangeMode, Class)}, i.e. if Integer.class was accepted this array's class will be Integer[], not
	 *            Object[].
	 * @param mode
	 */
	public abstract void change(T[] what, Object[] delta, ChangeMode mode);
	
	public abstract Class<?> acceptChange(ChangeMode mode);
	
}
