/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript;

import java.util.List;

import org.bukkit.event.Event;

import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.api.intern.TriggerItem;
import ch.njol.skript.api.intern.TriggerSection;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class Trigger extends TriggerSection {
	public final String name;
	SkriptEvent event;
	
	public Trigger(final String name, final SkriptEvent event, final List<TriggerItem> items) {
		super(items);
		this.name = name;
		this.event = event;
	}
	
	@Override
	public boolean run(final Event e) {
		if (Skript.log(Verbosity.VERY_HIGH))
			Skript.info("# " + name);
		super.run(e, event.check(e));
		return true;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		throw new RuntimeException("a trigger's debug message should not be used");
	}
	
}
