/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript;

import java.util.logging.Level;

import org.bukkit.Bukkit;

import ch.njol.skript.config.ConfigNode;

public abstract class SkriptLogger {
	
	private static ConfigNode node = null;
	
	static Verbosity verbosity = Verbosity.NORMAL;
	
	/**
	 * TODO copy this to all aliases usage:
	 * 
	 * <pre>
	 * if (Skript.log(someverbosity))
	 * 	Skript.log(somelevel, somestring);
	 * </pre>
	 * 
	 * the same applies to all aliases of this method (info, error, etc.)
	 * 
	 * @param msg
	 */
	static void log(final Level level, final String message) {
		if (node != null && (level == Level.SEVERE || level == Level.WARNING)) {
			if (node.getParent() != null)
				Bukkit.getLogger().log(level, "[Skript] " + message +
						" (" + node.getConfig().getFileName() + ", line " + node.getLine() + ": '" + node.getOrig().trim() + "')");
			else
				Bukkit.getLogger().log(level, "[Skript] " + message +
						" (" + node.getConfig().getFileName() + " [unknown line])");
		} else {
			Bukkit.getLogger().log(level, "[Skript] " + message);
		}
	}
	
	public static void expectationError(final String expectedType, final String found) {
		log(Level.SEVERE, "expecting " + expectedType + ", found: '" + found + "'");
	}
	
	public static void setNode(final ConfigNode node) {
		SkriptLogger.node = node;
	}
	
	/**
	 * checks whether messages should be logged for the given verbosity.
	 * 
	 * @param minVerb minimal verbosity
	 * @return
	 */
	public static boolean log(final Verbosity minVerb) {
		return minVerb.compareTo(verbosity) <= 0;
	}
	
}
