/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript;

import java.util.ArrayList;
import java.util.List;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

import ch.njol.skript.api.SimpleEvent;
import ch.njol.skript.api.intern.TriggerItem;

/**
 * This class is used for user-defined commands.
 * 
 * @author Peter Gttinger
 * 
 */
public class SkriptCommand extends Command {
	
	private final Trigger trigger;
	
	/**
	 * 
	 * @param name /name
	 * @param description
	 * @param usageMessage message to display if the command was used incorrectly (TODO)
	 * @param aliases /alias1, /alias2
	 * @param permission permission or null if none
	 * @param permissionMessage message to display if the player doesn't have the given permission
	 * @param items trigger to execute
	 */
	public SkriptCommand(final String name, final String description, final String usageMessage, final List<String> aliases, final String permission, final String permissionMessage, final List<TriggerItem> items) {
		super(name, description, usageMessage, aliases == null ? new ArrayList<String>(0) : aliases);
		trigger = new Trigger("command /" + name, new SimpleEvent(), items);
		setPermission(permission);
		setPermissionMessage(permissionMessage == null ? "you don't have the required permission to use this command" : permissionMessage);
	}
	
	@Override
	public boolean execute(final CommandSender sender, final String commandLabel, final String[] args) {
		return trigger.run(new CommandEvent(this, sender, args));
	}
	
}
