/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

/**
 * @author Peter Gttinger
 * 
 */
public class CommandEvent extends Event {
	
	private static final long serialVersionUID = 6297717648348714582L;
	
	private final SkriptCommand skriptCommand;
	private final CommandSender sender;
	private final String[] args;
	
	public CommandEvent(final SkriptCommand skriptCommand, final CommandSender sender, final String[] args) {
		this.skriptCommand = skriptCommand;
		this.sender = sender;
		this.args = args;
	}
	
	public Command getCommand() {
		return skriptCommand;
	}
	
	public CommandSender getSender() {
		return sender;
	}
	
	public String[] getArgs() {
		return args;
	}
	
}
