/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.util;

import java.util.Iterator;

public class ImprovedIterator<T> implements Iterator<T> {
	
	private final Iterator<T> iter;
	private T current = null;
	
	public ImprovedIterator(final Iterator<T> iter) {
		this.iter = iter;
	}
	
	@Override
	public boolean hasNext() {
		return iter.hasNext();
	}
	
	@Override
	public T next() {
		if (!hasNext())
			return null;
		return current = iter.next();
	}
	
	@Override
	public void remove() {
		iter.remove();
	}
	
	public T current() {
		return current;
	}
	
}
