/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.util;

public interface Checker<T> {
	
	public boolean check(T o);
	
	public static final Checker<Object> nullChecker = new Checker<Object>() {
		@Override
		public boolean check(final Object o) {
			return o != null;
		}
	};
	
}
