/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.util;

import java.util.Iterator;

public class CheckedIterator<T> implements Iterator<T> {
	
	private final Iterator<T> iter;
	private final Checker<T> checker;
	
	private T current;
	
	public CheckedIterator(final Iterator<T> iter, final Checker<T> checker) {
		this.iter = iter;
		this.checker = checker;
	}
	
	@Override
	public boolean hasNext() {
		if (current != null)
			return true;
		return next() != null;
	}
	
	@Override
	public T next() {
		if (current != null) {
			T t = current;
			current = null;
			return t;
		}
		while (iter.hasNext()) {
			current = iter.next();
			if (checker.check(current))
				return current;
		}
		return null;
	}
	
	@Override
	public void remove() {
		iter.remove();
	}
	
}
