/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Utils;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarTool extends Variable<ItemStack> {
	
	static {
		Skript.addVariable(VarTool.class, ItemStack.class, true, "tool");
	}
	
	@Override
	protected ItemStack[] getAll(final Event e) {
		final Player p = Skript.getEventValue(e, Player.class);
		if (p == null)
			return null;
		return new ItemStack[] {p.getItemInHand()};
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		final Player p = Skript.getEventValue(e, Player.class);
		if (p == null)
			return;
		final ItemStack is = Skript.convert(to[0], ItemStack.class);
		if (is == null)
			return;
		p.setItemInHand(is);
	}
	
	@Override
	public void add(final Event e, final Object[] add) {
		final Player p = Skript.getEventValue(e, Player.class);
		if (p == null)
			return;
		final ItemStack is = Skript.convert(add[0], ItemStack.class);
		Utils.add(is, p.getItemInHand());
	}
	
	@Override
	public void remove(final Event e, final Object[] rem) {
		final Player p = Skript.getEventValue(e, Player.class);
		if (p == null)
			return;
		final ItemStack is = Skript.convert(rem[0], ItemStack.class);
		Utils.remove(is, p.getItemInHand());
	}
	
	@Override
	public void clear(final Event e) {
		final Player p = Skript.getEventValue(e, Player.class);
		if (p == null)
			return;
		p.setItemInHand(null);
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
}
