/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.World;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Time;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarTime extends Variable<Time> {
	
	static {
		Skript.addVariable(VarTime.class, Time.class, true, "time( (in|of) %world%)?");
	}
	
	private Variable<World> worlds = null;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		worlds = (Variable<World>) vars.get(0);
	}
	
	@Override
	protected Time[] getAll(final Event e) {
		final World[] ws = worlds.get(e);
		final Time[] times = new Time[ws.length];
		for (int i = 0; i < ws.length; i++) {
			times[i] = new Time((int) ws[i].getTime());
		}
		return times;
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		final World[] ws = worlds.get(e);
		if (ws.length == to.length) {
			for (int i = 0; i < ws.length; i++) {
				final Time t = Skript.convert(to[i], Time.class);
				if (t == null)
					continue;
				ws[i].setTime(t.get());
			}
		} else {
			final Time t = Skript.convert(to[0], Time.class);
			if (t == null)
				return;
			for (final World w : ws)
				w.setTime(t.get());
		}
	}
	
	private void change(final Event e, final Object[] diff, final boolean add) {
		final World[] ws = worlds.get(e);
		if (ws.length == diff.length) {
			for (int i = 0; i < ws.length; i++) {
				final Time t = Skript.convert(diff[i], Time.class);
				if (t == null)
					continue;
				ws[i].setTime(ws[i].getTime() + (add ? t.get() : -t.get()));
			}
		} else {
			final Time t = Skript.convert(diff[1], Time.class);
			if (t == null)
				return;
			for (final World w : ws)
				w.setTime(w.getTime() + (add ? t.get() : -t.get()));
		}
	}
	
	@Override
	public void add(final Event e, final Object[] add) {
		change(e, add, true);
	}
	
	@Override
	public void remove(final Event e, final Object[] rem) {
		change(e, rem, false);
	}
	
	@Override
	public void clear(final Event e) {}
	
}
