/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.ConvertedVariable;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.Utils;

/**
 * @author Peter Gttinger
 * 
 */
public class VarTarget extends Variable<Object> {
	
	static {
		Skript.addVariable(VarTarget.class, Object.class, false,
				"targeted block( of %entity%)?",
				"target(ed %entitytype%)( of %entity%)?");
	}
	
	private Variable<EntityType> types = null;
	private Variable<Entity> entities;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		if (vars.size() == 1)
			types = (Variable<EntityType>) vars.get(0);
		entities = (Variable<Entity>) vars.get(vars.size() - 1);
	}
	
	@Override
	protected Object[] getAll(final Event evt) {
		if (this.types != null) {
			ArrayList<Entity> targets = new ArrayList<Entity>();
			EntityType[] types = this.types.get(evt);
			for (Entity e:entities.get(evt)) {
				for (EntityType type:types) {
					Entity t = Utils.getTargetEntity(e, type.c);
					if (t != null)
						targets.add(t);
				}
			}
			return targets.toArray(new Entity[0]);
		} else {
			ArrayList<Block> targets = new ArrayList<Block>();
			for (Entity e:entities.get(evt)) {
				if (!(e instanceof LivingEntity))
					continue;
				Block t = ((LivingEntity) e).getTargetBlock(null, Skript.TARGETBLOCKMAXDISTANCE);
				if (t != null)
					targets.add(t);
			}
			return targets.toArray(new Block[0]);
		}
	}

	protected <R> ConvertedVariable<?, R> getConvertedVar(Class<R> to) {
		if (types != null) {
			return ConvertedVariable.newInstance(this, Entity.class, to);
		} else {
			return ConvertedVariable.newInstance(this, Block.class, to);
		}
	}
	
	@Override
	public void set(final Event e, final Object[] to) {}
	
	@Override
	public void add(final Event e, final Object[] add) {}
	
	@Override
	public void remove(final Event e, final Object[] rem) {}
	
	@Override
	public void clear(final Event e) {}
	
}
