/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.ConvertedVariable;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.Variable;
import ch.njol.util.Pair;

/**
 * @author Peter Gttinger
 * 
 *         used to access a loop's current value.
 * 
 */
public class VarLoop extends Variable<Object> {
	
	static {
		Skript.addVariable(VarLoop.class, Object.class, false, "loop-(\\S+)");
	}
	
	private LoopVar<?> var;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		String s = matcher.group(1);
		int i = 1;
		final Matcher m = Pattern.compile("^(.+)-(\\d+)$").matcher(matcher.group(1));
		if (m.matches()) {
			s = m.group(1);
			i = Integer.parseInt(m.group(2));
		}
		for (final Pair<String, LoopVar<?>> p : TriggerFileLoader.currentLoops) {
			if (p.first.equalsIgnoreCase(s)) {
				if (i > 1) {
					i--;
					continue;
				}
				var = p.second;
				return;
			}
		}
		Skript.error("invalid loop variable '" + matcher.group() + "'");
	}

	protected <R> ConvertedVariable<?, R> getConvertedVar(Class<R> to) {
		return ConvertedVariable.newInstance(var, to);
	}
	
	@Override
	protected Object[] getAll(final Event e) {
		return var.get(e);
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		var.set(e, to);
	}
	
	@Override
	public void add(final Event e, final Object[] add) {
		var.add(e, add);
	}
	
	@Override
	public void remove(final Event e, final Object[] rem) {
		var.remove(e, rem);
	}
	
	@Override
	public void clear(final Event e) {
		var.clear(e);
	}
	
	@Override
	public void setAnd(final boolean and) {
		super.setAnd(and);
		var.setAnd(and);
	}
	
}
