/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Utils;

/**
 * @author Peter Gttinger
 * 
 */
public class VarFurnaceSlot extends Variable<ItemStack> {
	
	// Slot IDs:
	// ore: 0, fuel: 1, result: 2
	
	static {
		Skript.addVariable(VarFurnaceSlot.class, ItemStack.class, true, "ore( slot)?( of %block%)?", "fuel( slot)?( of %block%)?", "result( slot)?( of %block%)?");
	}
	
	private Variable<Block> blocks;
	private int slot;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		blocks = (Variable<Block>) vars.get(0);
		slot = matchedPattern;
	}
	
	@Override
	protected ItemStack[] getAll(final Event e) {
		final Block[] bs = blocks.get(e);
		if (bs == null)
			return null;
		final ItemStack[] iss = new ItemStack[bs.length];
		for (int i = 0; i < bs.length; i++) {
			if (bs[i].getType() != Material.FURNACE)
				continue;
			iss[i] = ((Furnace) bs[i].getState()).getInventory().getItem(slot);
		}
		return iss;
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		// FIXME
		final Block[] bs = blocks.get(e);
		if (bs == null)
			return;
		for (int i = 0; i < bs.length; i++) {
			if (bs[i].getType() != Material.FURNACE)
				continue;
			final ItemStack is = Skript.convert(to[i], ItemStack.class);
			if (is == null)
				continue;
			((Furnace) bs[i].getState()).getInventory().setItem(slot, is);
		}
	}
	
	@Override
	public void add(final Event e, final Object[] add) {
		// FIXME
		final Block[] bs = blocks.get(e);
		if (bs == null)
			return;
		for (int i = 0; i < bs.length; i++) {
			if (bs[i].getType() != Material.FURNACE)
				continue;
			final ItemStack is = Skript.convert(add[i], ItemStack.class);// add.length != bs.length?
			if (is == null)
				continue;
			final ItemStack current = ((Furnace) bs[i].getState()).getInventory().getItem(slot);
			if (!Utils.itemStacksEqual(current, is))
				continue;
			current.setAmount(current.getAmount() + is.getAmount());
		}
	}
	
	@Override
	public void remove(final Event e, final Object[] rem) {
		// FIXME
		
	}
	
	@Override
	public void clear(final Event e) {
		final Block[] bs = blocks.get(e);
		if (bs == null)
			return;
		for (final Block b : bs) {
			if (b.getType() != Material.FURNACE)
				continue;
			((Furnace) b.getState()).getInventory().setItem(slot, null);
		}
	}
	
}
