/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.ConvertedVariable;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 *         provided for convenience: one can write event-world to distinguish between the world named 'world', the event's world, and the loop's world for example.
 * 
 */
public class VarEventValue extends Variable<Object> {
	
	static {
		Skript.addVariable(VarEventValue.class, Object.class, true, "event-(\\S+)");
	}
	
	private Variable<?> var;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		var = Variable.parse(matcher.group(1), Object.class);
		if (var == null)
			Skript.printWithheldError();
	}

	protected <R> ConvertedVariable<?, R> getConvertedVar(Class<R> to) {
		return ConvertedVariable.newInstance(var, to);
	}
	
	@Override
	protected Object[] getAll(final Event e) {
		return var.get(e);
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		var.set(e, to);
	}
	
	@Override
	public void add(final Event e, final Object[] add) {
		var.add(e, add);
	}
	
	@Override
	public void remove(final Event e, final Object[] rem) {
		var.add(e, rem);
	}
	
	@Override
	public void clear(final Event e) {
		var.clear(e);
	}
	
	@Override
	public void setAnd(final boolean and) {
		super.setAnd(and);
		var.setAnd(and);
	}
	
}
