/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class VarEventCancelled extends Variable<Boolean> {
	
	static {
		Skript.addVariable(VarEventCancelled.class, Boolean.class, true, "event cancelled");
	}
	
	@Override
	protected Boolean[] getAll(final Event e) {
		if (!(e instanceof Cancellable))
			return null;
		return new Boolean[] {((Cancellable) e).isCancelled()};
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		if (!(e instanceof Cancellable))
			return;
		final Boolean b = Skript.convert(to[0], Boolean.class);
		if (b == null)
			return;
		((Cancellable) e).setCancelled(b);
	}
	
	@Override
	public void add(final Event e, final Object[] add) {}
	
	@Override
	public void remove(final Event e, final Object[] rem) {}
	
	@Override
	public void clear(final Event e) {}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
}
