/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Utils;

/**
 * @author Peter Gttinger
 * 
 */
public class VarDrops extends Variable<ItemStack> {
	
	static {
		Skript.addVariable(VarDrops.class, ItemStack.class, true, "drops");
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@Override
	protected ItemStack[] getAll(final Event e) {
		if (!(e instanceof EntityDeathEvent))
			return null;
		return ((EntityDeathEvent) e).getDrops().toArray(new ItemStack[0]);
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		if (!(e instanceof EntityDeathEvent))
			return;
		final List<ItemStack> drops = ((EntityDeathEvent) e).getDrops();
		drops.clear();
		for (final Object o : to) {
			final ItemStack is = Skript.convert(o, ItemStack.class);
			if (is == null)
				continue;
			drops.add(is);
		}
	}
	
	@Override
	public void add(final Event e, final Object[] add) {
		if (!(e instanceof EntityDeathEvent))
			return;
		final List<ItemStack> drops = ((EntityDeathEvent) e).getDrops();
		for (final Object o : add) {
			final ItemStack is = Skript.convert(o, ItemStack.class);
			if (is == null)
				continue;
			drops.add(is);
		}
	}
	
	@Override
	public void remove(final Event e, final Object[] rem) {
		if (!(e instanceof EntityDeathEvent))
			return;
		final List<ItemStack> drops = ((EntityDeathEvent) e).getDrops();
		for (final Object o : rem) {
			final ItemStack is = Skript.convert(o, ItemStack.class);
			if (is == null)
				continue;
			Utils.removeItemStack(drops, is, null);
		}
	}
	
	@Override
	public void clear(final Event e) {
		if (!(e instanceof EntityDeathEvent))
			return;
		((EntityDeathEvent) e).getDrops().clear();
	}
	
}
