/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.block.Block;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Offset;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarBlock extends Variable<Block> {
	
	static {
		Skript.addVariable(VarBlock.class, Block.class, true, "block", "block-(\\S+)");
	}
	
	private Offset offset = null;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		if (matchedPattern == 1) {
			offset = new Offset(matcher.group(1).split("-"));
		}
	}
	
	private Block setOff(final Block b) {
		if (offset == null)
			return b;
		return offset.setOff(b);
	}
	
	@Override
	protected Block[] getAll(final Event e) {
		return new Block[] {setOff(Skript.getEventValue(e, Block.class))};
	}
	
	@Override
	public void set(final Event e, final Object[] to) {
		final Block b = setOff(Skript.getEventValue(e, Block.class));
		if (b == null)
			return;
		final ItemType i = Skript.convert(to[0], ItemType.class);
		if (i == null)
			return;
		i.setBlock(b, true);
	}
	
	@Override
	public void add(final Event e, final Object[] add) {}
	
	@Override
	public void remove(final Event e, final Object[] rem) {}
	
	@Override
	public void clear(final Event e) {
		final Block b = setOff(Skript.getEventValue(e, Block.class));
		if (b == null)
			return;
		b.setTypeId(0);
	}
	
}
