/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarArg extends Variable<String> {
	
	static {
		Skript.addVariable(VarArg.class, String.class, false, "arg(ument)? (number |# ?)?%integer%");
	}
	
	Variable<Integer> nums;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		nums = (Variable<Integer>) vars.get(0);
	}
	
	@Override
	protected String[] getAll(final Event e) {
		if (!(e instanceof PlayerCommandPreprocessEvent || e instanceof ServerCommandEvent))
			return null;
		final Integer[] ns = nums.get(e);
		if (ns == null)
			return null;
		final String[] args = new String[ns.length];
		String[] command;
		if (e instanceof PlayerCommandPreprocessEvent)
			command = ((PlayerCommandPreprocessEvent) e).getMessage().substring(1).split(" ");
		else
			command = ((ServerCommandEvent) e).getCommand().substring(1).split(" ");
		for (int i = 0; i < ns.length; i++) {
			args[i] = command[ns[i]];
		}
		return args;
	}
	
	@Override
	public void set(final Event e, final Object[] to) {}
	
	@Override
	public void add(final Event e, final Object[] add) {}
	
	@Override
	public void remove(final Event e, final Object[] rem) {}
	
	@Override
	public void clear(final Event e) {}
	
}
