/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

import java.util.Locale;

import org.bukkit.World;

import ch.njol.skript.api.Debuggable;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public enum WeatherType implements Debuggable {
	clear, rain, thunder;
	
	public static final WeatherType parse(final String s) {
		if (s.endsWith("ing")) {
			try {
				return WeatherType.valueOf(s.substring(0, s.length() - 3).toLowerCase(Locale.ENGLISH));
			} catch (final IllegalArgumentException e) {
				return null;
			}
		}
		try {
			return WeatherType.valueOf(s.toLowerCase(Locale.ENGLISH));
		} catch (final IllegalArgumentException e) {
			return null;
		}
	}
	
	public static WeatherType get(final World world) {
		if (world.isThundering())
			return thunder;
		if (world.hasStorm())
			return rain;
		return clear;
	}
	
	@Override
	public String getDebugMessage() {
		return super.toString();
	}
	
	@Override
	public String toString() {
		switch (this) {
			case clear:
				return "clear";
			case rain:
				return "rain";
			case thunder:
				return "thunder";
		}
		return null;
	}
	
	public String adjective() {
		switch (this) {
			case clear:
				return "sunny";
			case rain:
				return "raining";
			case thunder:
				return "thundering";
		}
		return null;
	}
}
