/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public abstract class SimpleVar<T> extends Variable<T> {
	
	Class<T> c;
	
	public SimpleVar(final Class<T> c) {
		this.c = c;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected T[] getAll(final Event e) {
		final T[] t = (T[]) Array.newInstance(c, 1);
		t[0] = Skript.getEventValue(e, c);
		return t;
	}
	
	@Override
	public void set(final Event e, final Object[] to) {}
	
	@Override
	public void add(final Event e, final Object[] add) {}
	
	@Override
	public void remove(final Event e, final Object[] rem) {}
	
	@Override
	public void clear(final Event e) {}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
}
